
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_Division : BaseTest 
	{
		private DataTable _dtDivision;	
		private string _junkDivisionCode = "";

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtDivision = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM VamcDivision WHERE DivisionCode != '" + this._junkDivisionCode + "'", true);
				this._junkDivisionCode = this._dtDivision.Rows[0][TABLES.VamcDivision.DivisionCode].ToString();

				this.RefreshData = false;
			}
		}


		[Test]
		public void GetDivision_Pass()
		{
			DataRow drTest = DAL.Division.GetDivision(UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(drTest!=null & drTest.Table.Columns.Count>0);
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetDivision_Fail()
		{
			DataRow drTest = DAL.Division.GetDivision(string.Empty);
		}

		[Test]
		public void GetDivisions_Pass_1()
		{
			DataTable dtTest = DAL.Division.GetDivisions( false );			
			Assert.IsTrue( dtTest.Rows.Count > 0 );

			Assert.AreEqual( 37, dtTest.Columns.Count );
		}

		[Test]
		public void GetDivisions_Pass_2()
		{
			DataTable dtTest = DAL.Division.GetDivisions( true );			
			Assert.IsTrue( dtTest.Rows.Count > 0 );

			Assert.AreEqual( 37, dtTest.Columns.Count );

			foreach( DataRow dr in dtTest.Rows )
				if( Convert.ToChar( dr[ TABLES.VamcDivision.RecordStatusCode ] ) != 'A' )
					Assert.Fail( "Inactive division was returned when only active were expected." );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllDivisions_Fail() {}


		[Test]
		public void UpdateDivision_Pass()
		{	
			bool electronicCrossmatchIndicator = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.ElectronicCrossmatchIndicator)) ? false : (bool)this._dtDivision.Rows[0][TABLES.VamcDivision.ElectronicCrossmatchIndicator];
			string iccba = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.IccbbaRegistrationNumber)) ? string.Empty : this._dtDivision.Rows[0][TABLES.VamcDivision.IccbbaRegistrationNumber ].ToString();
			int antibodyScreenDisplayCode = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.AntibodyScreenDisplayCode)) ? 1 : System.Convert.ToInt32(this._dtDivision.Rows[0][TABLES.VamcDivision.AntibodyScreenDisplayCode]);
			bool automatedInstrumentIndicator = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.AutomatedInstrumentIndicator)) ? false : (bool)this._dtDivision.Rows[0][TABLES.VamcDivision.AutomatedInstrumentIndicator];
			string medicalDirector = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.MedicalDirectorName)) ? string.Empty : this._dtDivision.Rows[0][TABLES.VamcDivision.MedicalDirectorName ].ToString();
			bool iconAlertsIndicator = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.IconAlertsIndicator)) ? false : (bool)this._dtDivision.Rows[0][TABLES.VamcDivision.IconAlertsIndicator];
			int iconOrdersNeededHours = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.IconOrdersNeededHours)) ? 1 : System.Convert.ToInt32(this._dtDivision.Rows[0][TABLES.VamcDivision.IconOrdersNeededHours]);
			int iconRefreshRate = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.IconRefreshRate)) ? 1 : System.Convert.ToInt32(this._dtDivision.Rows[0][TABLES.VamcDivision.IconRefreshRate].ToString());
			bool printAlertsIndicator = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.PrinterAlertsIndicator)) ? false : (bool)this._dtDivision.Rows[0][TABLES.VamcDivision.PrinterAlertsIndicator];
			string printerName = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.PrinterAlertsPrinterName)) ? string.Empty : this._dtDivision.Rows[0][TABLES.VamcDivision.PrinterAlertsPrinterName ].ToString();
			int printOrdersNeededHours = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.PrinterOrdersNeededHours)) ? 1 : System.Convert.ToInt32(this._dtDivision.Rows[0][TABLES.VamcDivision.PrinterOrdersNeededHours]);
			string loginMessage = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.LoginMessageText)) ? System.DateTime.Now.ToString() : this._dtDivision.Rows[0][TABLES.VamcDivision.LoginMessageText ].ToString();
			int maximumSpecimenExpirationDays = (this._dtDivision.Rows[0].IsNull(TABLES.VamcDivision.MaximumSpecimenExpirationDays)) ? 7 : System.Convert.ToInt32(this._dtDivision.Rows[0][TABLES.VamcDivision.MaximumSpecimenExpirationDays]);

			bool retValue = DAL.Division.UpdateDivision(this._junkDivisionCode,
				electronicCrossmatchIndicator, iccba, antibodyScreenDisplayCode,
				automatedInstrumentIndicator,medicalDirector, iconAlertsIndicator, Common.OrderAlertTypeCode.All_orders,
				iconOrdersNeededHours, iconRefreshRate, printAlertsIndicator, printerName, Common.OrderAlertTypeCode.All_orders,
				printOrdersNeededHours, loginMessage, maximumSpecimenExpirationDays , (byte[])this._dtDivision.Rows[0][TABLES.VamcDivision.RowVersion], Common.UpdateFunction.UnitTests, Common.ReactivityPhase.IS);

			//All we're changing is the login message, so I'm not worried about data cleanup
			Assert.IsTrue(retValue == true);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void UpdateDivision_Fail()
		{			
			bool retValue = DAL.Division.UpdateDivision(this._junkDivisionCode, false, new Random().Next(99).ToString(), 1, false, System.DateTime.Now.ToString(), false, Common.OrderAlertTypeCode.All_orders, 1, 5,false, "Test",Common.OrderAlertTypeCode.Hour_limit,
				1,System.DateTime.Now.ToString(), 20, new byte[8], Common.UpdateFunction.UnitTests, Common.ReactivityPhase.IS);

		}

		[Test]
		public void GetMedicalDirectorNames_Pass()
		{
			DataTable dtTest = DAL.Division.GetMedicalDirectorNames(UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.IsTrue(dtTest.Columns.Count == 1);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.VamcDivision.MedicalDirectorName));
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetMedicalDirectorNames_Fail()
		{			
			DataTable dtTest = DAL.Division.GetMedicalDirectorNames(null);
		}	

		[Test]
		public void IsBloodUnitNotInFinalStatus_Pass()
		{
			bool retValue = DAL.Division.IsBloodUnitNotInFinalStatus(this.TestDivisionCode);

			Assert.IsNotNull(retValue);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void IsBloodUnitNotInFinalStatus_Fail()
		{
			bool retValue = DAL.Division.IsBloodUnitNotInFinalStatus(null);
		}

		
		[Test]
		public void PersistDivisionBaseData_Pass()
		{
			IList tmpList = BOL.DivisionBase.GetBaseInfoForAllVbecsDivisions();
			BOL.DivisionBase tmpBase = null;
			foreach(object tmpDiv in tmpList)
			{
				if (((BOL.DivisionBase)tmpDiv).DivisionCode != this.TestDivisionCode)
				{
					tmpBase = (BOL.DivisionBase)tmpDiv;
				}
			}

			string name = tmpBase.DivisionName;

			tmpBase.DivisionName = "test 123";
			tmpBase.PersistDivisionBase( Common.UpdateFunction.MUC02_EditDivisionParameters);

			IList tmpList2 = BOL.DivisionBase.GetBaseInfoForAllVbecsDivisions();
			BOL.DivisionBase tmpBase2 = null;
			foreach(object tmpDiv2 in tmpList2)
			{
				if (((BOL.DivisionBase)tmpDiv2).DivisionCode != this.TestDivisionCode)
				{
					tmpBase2 = (BOL.DivisionBase)tmpDiv2;
				}
			}
	
			Assert.AreEqual(tmpBase2.DivisionName, "test 123","Division Update");
			DataTable dtAssociatedInstitutions = DAL.Division.GetAssociatedInstitutionsByDivision(tmpBase.DivisionCode);

			//New Division
			DataTable dtDivision = new DataTable(TABLES.VamcDivision.TableName);
			dtDivision.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.DivisionName, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.DivisionGuid, typeof(System.Guid));
			dtDivision.Columns.Add(TABLES.VamcDivision.FacilityGuid, typeof(System.Guid));
			dtDivision.Columns.Add(TABLES.VamcDivision.LocalSupplierGuid, typeof(System.Guid));
			dtDivision.Columns.Add(TABLES.VamcDivision.AccessionAreaId, typeof(int));
			dtDivision.Columns.Add(TABLES.VamcDivision.ServiceTypeIndicator, typeof(bool));
			dtDivision.Columns.Add(TABLES.VamcDivision.LabelPrinterUseIndicator, typeof(bool));
			dtDivision.Columns.Add(TABLES.VamcDivision.PrinterName, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.DaylightSavingsTypeId, typeof(int));
			dtDivision.Columns.Add(TABLES.VamcDivision.LockInactivityTimeoutMin, typeof(int));
			dtDivision.Columns.Add(TABLES.VamcDivision.TimeZoneId, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.InvoiceTemplateText, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.RecordStatusCode, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.LastUpdateUser, typeof(string));
			dtDivision.Columns.Add(TABLES.VamcDivision.LastUpdateFunctionId, typeof(int));
			dtDivision.Columns.Add(TABLES.VamcDivision.LastUpdateDate, typeof(System.DateTime));

			string newDivision = new Random().Next(11111,99999).ToString();
			System.Guid addressGuid = System.Guid.NewGuid();
			System.Guid localSupplierGuid = System.Guid.NewGuid();
			System.Guid divisionGuid = System.Guid.NewGuid();
			System.Guid facilityGuid = DataCreator.GetRecordGuid("SELECT TOP 1 FacilityGuid FROM Facility WHERE FacilityGuid NOT IN (SELECT FacilityGuid FROM LocalSupplier WHERE FacilityGuid IS NOT NULL)");

			DataRow dr = dtDivision.NewRow();
			dr[TABLES.VamcDivision.DivisionCode] = newDivision;
			dr[TABLES.VamcDivision.DivisionName] = System.DateTime.Now.ToString();
			dr[TABLES.VamcDivision.DivisionGuid] = divisionGuid;
			dr[TABLES.VamcDivision.FacilityGuid] = facilityGuid;
			dr[TABLES.VamcDivision.LocalSupplierGuid] = localSupplierGuid;
			dr[TABLES.VamcDivision.AccessionAreaId] = 9;
			dr[TABLES.VamcDivision.ServiceTypeIndicator] = false;
			dr[TABLES.VamcDivision.LabelPrinterUseIndicator] = false;
			dr[TABLES.VamcDivision.PrinterName] = "Test8248 Printer";
			dr[TABLES.VamcDivision.DaylightSavingsTypeId] = 1;
			dr[TABLES.VamcDivision.LockInactivityTimeoutMin] = 5;
			dr[TABLES.VamcDivision.TimeZoneId] = "S";
			dr[TABLES.VamcDivision.InvoiceTemplateText] = System.DateTime.Now.ToString();
			dr[TABLES.VamcDivision.RecordStatusCode] = "A";
			dr[TABLES.VamcDivision.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.VamcDivision.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.VamcDivision.LastUpdateDate] = System.DateTime.Now;
		
			dtDivision.Rows.Add(dr);

			DataTable dtAddress = SprocHelper.GetInsertAddressSprocTable(addressGuid);
				
			DataTable dtLocalSupplier = new DataTable();
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.LocalSupplierGuid, typeof(System.Guid));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.FacilityGuid, typeof(System.Guid));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.AddressGuid, typeof(System.Guid));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.FdaRegistrationNumber, typeof(string));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.FacilityName, typeof(string));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.DivisionCode, typeof(string));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.RecordStatusCode, typeof(string));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.LastUpdateUser, typeof(string));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.LastUpdateFunctionId, typeof(int));
			dtLocalSupplier.Columns.Add(TABLES.LocalSupplier.LastUpdateDate, typeof(System.DateTime));

			DataRow newLS = dtLocalSupplier.NewRow();
			newLS[TABLES.LocalSupplier.LocalSupplierGuid] = localSupplierGuid;
			newLS[TABLES.LocalSupplier.FacilityGuid] = facilityGuid;
			newLS[TABLES.LocalSupplier.AddressGuid] = addressGuid;
			//This might fail.. so code something more reliable someday
			newLS[TABLES.LocalSupplier.FdaRegistrationNumber] = "12345" + new Random().Next(11111,99999).ToString();
			newLS[TABLES.LocalSupplier.FacilityName] = "Test8248";
			newLS[TABLES.LocalSupplier.DivisionCode] = newDivision;
			newLS[TABLES.LocalSupplier.RecordStatusCode] = "A";
			newLS[TABLES.LocalSupplier.LastUpdateUser] = Common.LogonUser.LogonUserName;
			newLS[TABLES.LocalSupplier.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			newLS[TABLES.LocalSupplier.LastUpdateDate] = System.DateTime.Now;
			dtLocalSupplier.Rows.Add(newLS);

			DataTable dtUsers = new DataTable();		//blank for now
			System.Collections.ArrayList alRoles = new System.Collections.ArrayList();		//ditto

			DAL.Division.PersistDivisionBaseData(true, dtDivision, dtLocalSupplier, dtAddress, true, true, dtUsers, alRoles, dtAssociatedInstitutions, Common.UpdateFunction.UnitTests);
			Assert.IsTrue(true, "New Division Inserted");

			BOL.Division tmpDiv3 = new BOL.Division(newDivision);
			Assert.AreEqual(divisionGuid, tmpDiv3.DivisionGuid, "New Division Guid" );
		}

		[Test]
		public void PersistDivisionBaseData_Fail()
		{
			//Null DivBaseData
			try
			{
				DAL.Division.PersistDivisionBaseData(false,null, new DataTable(), new DataTable(), false,false, new DataTable(), new System.Collections.ArrayList(), new DataTable(), Common.UpdateFunction.MUC02_EditDivisionParameters);
				Assert.Fail("Null divBaseData expected");
			}
			catch(ArgumentNullException)
			{
				Assert.IsTrue(true, "Null divBaseData");
			}

			//Empty DivBaseData
			try
			{
				DAL.Division.PersistDivisionBaseData(false,new DataTable(), new DataTable(), new DataTable(), false,false, new DataTable(), new System.Collections.ArrayList(), new DataTable(), Common.UpdateFunction.MUC02_EditDivisionParameters);
				Assert.Fail("Empty divBaseData expected");
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true, "Empty divBaseData");
			}

		}
		
		[Test]
		public void GetAssociatedInstitutionsByDivision_Pass()
		{
			DataTable dtTest = DAL.Division.GetAssociatedInstitutionsByDivision(UnitTestConfig.TestDivisionCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
			Assert.IsTrue(dtTest.Columns.Contains(TABLES.AssociatedInstitution.InstitutionDivisionCode));
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetAssociatedInstitutionsByDivision__Fail()
		{			
			DataTable dtTest = DAL.Division.GetAssociatedInstitutionsByDivision(null);
		}	


	}
}
#endif
